//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;

namespace FrameworkLibraries
{
	public class DateTimeMain 
	{
		static void Main(string [] args)
		{
			Console.WriteLine("Min: {0}", DateTime.MinValue);
			Console.WriteLine("Max: {0}", DateTime.MaxValue);
			DateTime date = DateTime.Now;
			Console.WriteLine("Long DateTime {0} {1}",
				              date.ToLongDateString(),
				              date.ToLongTimeString());
			Console.WriteLine("Data: {0}", date.Date);
			Console.WriteLine("Miesic: {0}", date.Month);
			Console.WriteLine("Dzie: {0}", date.Day);
			Console.WriteLine("Dzie tygodnia: {0}", date.DayOfWeek);
			Console.WriteLine("Dzie roku: {0}", date.DayOfYear);
			Console.WriteLine("TimeOfDay: {0}", date.TimeOfDay);
			Console.WriteLine("Godzina: {0}", date.Hour);
			Console.WriteLine("Minut: {0}", date.Minute);
			Console.WriteLine("Sekund: {0}", date.Second);
			Console.WriteLine("Milisekund: {0}", date.Millisecond);
			Console.WriteLine("Taktw: {0}", date.Ticks);
			Console.WriteLine("Za godzin bdzie: {0} {1}",
				              date.AddHours(1).ToLongDateString(),
				              date.AddHours(1).ToLongTimeString());
			Console.WriteLine("Godzin temu byo: {0} {1}",
				              date.AddHours(-1).ToLongDateString(),
				              date.AddHours(-1).ToLongTimeString());
			Console.WriteLine("Jutro bdzie: {0} {1}",
				              date.AddDays(1).ToLongDateString(),
				              date.AddDays(1).ToLongTimeString());
			Console.WriteLine("Wczoraj by: {0} {1}",
				              date.AddDays(-1).ToLongDateString(),
				              date.AddDays(-1).ToLongTimeString());
			Console.WriteLine("Za tydzie bdzie: {0} {1}",
				              date.AddDays(7).ToLongDateString(),
				              date.AddDays(7).ToLongTimeString());
			Console.WriteLine("Tydzie temu by: {0} {1}",
				              date.AddDays(-7).ToLongDateString(),
				              date.AddDays(-7).ToLongTimeString());
			Console.WriteLine("Za miesic bdzie: {0} {1}",
				              date.AddMonths(1).ToLongDateString(),
				              date.AddMonths(1).ToLongTimeString());
			Console.WriteLine("Miesic temu by: {0} {1}",
				              date.AddMonths(-1).ToLongDateString(),
				              date.AddMonths(-1).ToLongTimeString());
		}
	}
}